<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>Rent a MailBox</title>

    <link rel="stylesheet" href="<?php echo e(asset('website.css')); ?>" type="text/css" />
    <link href="<?php echo e(asset('src/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('src/assets/css/light/elements/alert.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('src/assets/css/dark/elements/alert.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('layouts/modern-light-menu/css/light/plugins.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('layouts/modern-light-menu/css/dark/plugins.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('layouts/modern-light-menu/css/light/loader.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('layouts/modern-light-menu/css/dark/loader.css')); ?>" rel="stylesheet" type="text/css" />
    <script src="<?php echo e(asset('layouts/modern-light-menu/loader.js')); ?>"></script>
    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('favicon.ico')); ?>" />

    

    <link href="<?php echo e(asset('src/assets/css/light/pages/knowledge_base.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('src/assets/css/dark/pages/knowledge_base.css')); ?>" rel="stylesheet" type="text/css" />

    <link href="<?php echo e(asset('src/assets/css/light/pages/faq.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('src/assets/css/dark/pages/faq.css')); ?>" rel="stylesheet" type="text/css" />

    

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('src/assets/css/light/forms/switches.css')); ?>">
    <link href="<?php echo e(asset('src/plugins/css/light/pricing-table/css/component.css')); ?>" rel="stylesheet"
        type="text/css" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('src/assets/css/dark/forms/switches.css')); ?>">
    <link href="<?php echo e(asset('src/plugins/css/dark/pricing-table/css/component.css')); ?>" rel="stylesheet"
        type="text/css" />
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('src/plugins/src/notification/snackbar/snackbar.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('src/plugins/css/light/notification/snackbar/custom-snackbar.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('src/plugins/css/dark/notification/snackbar/custom-snackbar.css')); ?>">



</head>

<body class="layout-boxed">

    <!-- BEGIN LOADER -->
    <div id="load_screen">
        <div class="loader">
            <div class="loader-content">
                <div class="spinner-grow align-self-center"></div>
            </div>
        </div>
    </div>
    <!--  END LOADER -->

    <!--  BEGIN NAVBAR  -->
    <!-- Navbar Goes Here -->
    <!--  END NAVBAR  -->

    <!--  BEGIN MAIN CONTAINER  -->
    <div class="main-container " id="container">

        <div class="overlay"></div>
        <div class="search-overlay"></div>


        <!--  BEGIN CONTENT AREA  -->
        <div id="content" class="main-content ms-0 mt-0">
            <div class="hero-area pt-4">
                <div class="middle-content">
                    <div class="header">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex justify-content-between">
                                    <div class="align-self-center">
                                        <img src="<?php echo e(asset('rent-a-mailbox.png')); ?>" width="100" alt="">
                                    </div>
                                    <div class="align-self-center">
                                        <?php if(Auth::check()): ?>
                                            <a href="<?php echo e(url('app')); ?>" class="btn btn-primary">Dashboard</a>
                                        <?php else: ?>
                                            <a href="<?php echo e(url('app/login')); ?>" class="btn btn-primary">Login</a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="middle-content text-center">
                        <div class="hero-content">
                            <div class="row">
                                <div class="hero-content-left">
                                    <h1 style="font-size: 70px">
                                        <b>
                                            Virtual Mailbox Service <br> Now <span
                                                style="color: #d3c7f9">Available!</span>
                                        </b>
                                    </h1>
                                    <h5 class="mt-5 hero-h5 mb-4">Get a virtual mailbox for your business and personal
                                        use. We
                                        provide
                                        a physical address for you to receive your mail and packages. You
                                        can view and manage your mail from anywhere with an internet
                                        connection.</h5>
                                    <img src="<?php echo e(asset('src/assets/images/shopping-order-delivery-tracking-4268120-3550584.webp')); ?>"
                                        alt="" srcset="">
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>

            <div class="container section">
                
                <p>
                    Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the
                    industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type
                    and scrambled it to make a type specimen book. It has survived not only five centuries, but also the
                    leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s
                    with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop
                    publishing software like Aldus PageMaker including versions of Lorem Ipsum.
                </p>
            </div>

            <div class="container section">
                <h1 class="mb-4 heading-text">Feature</h1>

                <div class="faq container">

                    <div class="faq-layouting layout-spacing">

                        <div class="kb-widget-section">

                            <div class="row justify-content-center">

                                <div class="col-xxl-2 col-xl-3 col-lg-3 mb-lg-0 col-md-6 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                    viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                    stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                    class="feather feather-airplay">
                                                    <path
                                                        d="M5 17H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2h-1">
                                                    </path>
                                                    <polygon points="12 15 17 21 7 21 12 15"></polygon>
                                                </svg>
                                            </div>
                                            <h5 class="card-title mb-0">General</h5>
                                            <p class="mt-2">
                                                Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xxl-2 col-xl-3 col-lg-3 mb-lg-0 col-md-6 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                    viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                    stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                    class="feather feather-user">
                                                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                                    <circle cx="12" cy="7" r="4"></circle>
                                                </svg>
                                            </div>
                                            <h5 class="card-title mb-0">Quick Support</h5>
                                            <p class="mt-2">
                                                Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xxl-2 col-xl-3 col-lg-3 mb-lg-0 col-md-6 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                    viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                    stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                    class="feather feather-package">
                                                    <line x1="16.5" y1="9.4" x2="7.5"
                                                        y2="4.21"></line>
                                                    <path
                                                        d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z">
                                                    </path>
                                                    <polyline points="3.27 6.96 12 12.01 20.73 6.96"></polyline>
                                                    <line x1="12" y1="22.08" x2="12"
                                                        y2="12"></line>
                                                </svg>
                                            </div>
                                            <h5 class="card-title mb-0">Free Updates</h5>
                                            <p class="mt-2">
                                                Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-xxl-2 col-xl-3 col-lg-3 mb-lg-0 col-md-6 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                    viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                    stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                    class="feather feather-dollar-sign">
                                                    <line x1="12" y1="1" x2="12"
                                                        y2="23"></line>
                                                    <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                                                </svg>
                                            </div>
                                            <h5 class="card-title mb-0">Pricing</h5>
                                            <p class="mt-2">
                                                Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-2 col-xl-3 col-lg-3 mb-lg-0 col-md-6 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                    viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                                    stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                                    class="feather feather-dollar-sign">
                                                    <line x1="12" y1="1" x2="12"
                                                        y2="23"></line>
                                                    <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                                                </svg>
                                            </div>
                                            <h5 class="card-title mb-0">Pricing</h5>
                                            <p class="mt-2">
                                                Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>



            <div class="container section">
                <h1 class="heading-text" style="padding-bottom: 0px">Price Plan</h1>

                <div class="pricing-table-2 ">

                    <!-- Billing Cycle  -->
                    <div class="billing-cycle-radios mt-5">

                        <div class="switch form-switch-custom switch-inline form-switch-primary form-switch-custom inner-label-toggle show"
                            id="type-button">
                            <div class="input-checkbox">
                                <span class="switch-chk-label label-left">Monthly</span>
                                <input class="switch-input" type="checkbox" role="switch" id="toggle-1" checked>
                                <span class="switch-chk-label label-right">Yearly</span>
                            </div>
                        </div>

                    </div>


                    <div class="pricing-plans-container mt-5 billed-yearly" id="package">
                    </div>

                </div>
            </div>







            <div class="container section">
                <div class="faq">
                    <div class="faq-layouting layout-spacing">

                        <div class="fq-tab-section">
                            <div class="row">
                                <div class="col-md-12">

                                    <h2>Frequently Asked <span>Questions</span></h2>

                                    <div class="row">

                                        <div class="col-lg-6">

                                            <div class="accordion" id="simple_faq">
                                                <div class="card">
                                                    <div class="card-header" id="fqheadingOne">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseOne"
                                                            aria-expanded="false" aria-controls="fqcollapseOne">
                                                            <span class="faq-q-title">Getting started</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseOne" class="collapse"
                                                        aria-labelledby="fqheadingOne" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingTwo">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseTwo"
                                                            aria-expanded="false" aria-controls="fqcollapseTwo">
                                                            <span class="faq-q-title">How can I unzip product
                                                                files</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-up">
                                                                    <polyline points="18 15 12 9 6 15"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseTwo" class="collapse"
                                                        aria-labelledby="fqheadingTwo" data-bs-parent="#simple_faq"
                                                        style="">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingThree">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseThree"
                                                            aria-expanded="false" aria-controls="fqcollapseThree">
                                                            <span class="faq-q-title">Sidebar not rendering
                                                                CSS</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseThree" class="collapse"
                                                        aria-labelledby="fqheadingThree" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingFour">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseFour"
                                                            aria-expanded="false" aria-controls="fqcollapseFour">
                                                            <span class="faq-q-title">Production Level Built</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseFour" class="collapse"
                                                        aria-labelledby="fqheadingFour" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingFive">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseFive"
                                                            aria-expanded="false" aria-controls="fqcollapseFive">
                                                            <span class="faq-q-title">Compilation Issue</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseFive" class="collapse"
                                                        aria-labelledby="fqheadingFive" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingSix">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseSix"
                                                            aria-expanded="false" aria-controls="fqcollapseSix">
                                                            <span class="faq-q-title">Getting started with starter
                                                                kits</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseSix" class="collapse"
                                                        aria-labelledby="fqheadingSix" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">

                                            <div class="accordion" id="simple_faq1">
                                                <div class="card">
                                                    <div class="card-header" id="fqheadingOne1">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseOne1"
                                                            aria-expanded="false" aria-controls="fqcollapseOne1">
                                                            <span class="faq-q-title">Are images are provided in
                                                                the
                                                                download version?</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseOne1" class="collapse"
                                                        aria-labelledby="fqheadingOne1" data-bs-parent="#simple_faq1">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingTwo2">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseTwo2"
                                                            aria-expanded="false" aria-controls="fqcollapseTwo2">
                                                            <span class="faq-q-title">How can I customize APPS
                                                                sections?</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-up">
                                                                    <polyline points="18 15 12 9 6 15"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseTwo2" class="collapse"
                                                        aria-labelledby="fqheadingTwo2" data-bs-parent="#simple_faq1">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingThree3">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseThree3"
                                                            aria-expanded="false" aria-controls="fqcollapseThree3">
                                                            <span class="faq-q-title">Getting started with multiple
                                                                layouts</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseThree3" class="collapse"
                                                        aria-labelledby="fqheadingThree3"
                                                        data-bs-parent="#simple_faq1">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingFour4">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseFour4"
                                                            aria-expanded="false" aria-controls="fqcollapseFour4">
                                                            <span class="faq-q-title">How to use task
                                                                managers?</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseFour4" class="collapse"
                                                        aria-labelledby="fqheadingFour4"
                                                        data-bs-parent="#simple_faq1">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingFive5">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseFive5"
                                                            aria-expanded="false" aria-controls="fqcollapseFive5">
                                                            <span class="faq-q-title">How to setup a vpn?</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseFive5" class="collapse"
                                                        aria-labelledby="fqheadingFive5"
                                                        data-bs-parent="#simple_faq1">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingSix6">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseSix6"
                                                            aria-expanded="false" aria-controls="fqcollapseSix6">
                                                            <span class="faq-q-title">Chrome vs Edge which is
                                                                better!</span>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseSix6" class="collapse"
                                                        aria-labelledby="fqheadingSix6" data-bs-parent="#simple_faq1"
                                                        style="">
                                                        <div class="card-body">
                                                            <p>Anim pariatur cliche reprehenderit, enim eiusmod high
                                                                life accusamus terry richardson ad squid. 3 wolf
                                                                moon
                                                                officia aute, non cupidatat skateboard dolor brunch.
                                                                Food truck quinoa nesciunt laborum eiusmod. Brunch 3
                                                                wolf moon tempor, sunt aliqua put a bird on it squid
                                                                single-origin coffee nulla assumenda shoreditch et.
                                                                Nihil anim keffiyeh helvetica, craft beer labore wes
                                                                anderson cred nesciunt sapiente ea proident. Ad
                                                                vegan
                                                                excepteur butcher vice lomo. Leggings occaecat craft
                                                                beer farm-to-table, raw denim aesthetic synth
                                                                nesciunt
                                                                you probably haven't heard of them accusamus labore
                                                                sustainable VHS.</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>


                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>

            <div class="container section">
                <h1 class="heading-text" style="padding-top: 0px">Contact Us</h1>

                <div class="row">

                    <h4 class="mb-4 mt-4">
                        <u>
                            Lets Talk
                        </u>
                    </h4>

                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">New York</h5>
                                <p class="mb-0">+1 212-998-1212</p>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">
                                    Miami
                                </h5>
                                <p class="mb-0">
                                    +1 305-998-1212
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">
                                    Edinburgh
                                </h5>
                                <p class="mb-0">
                                    +44 131-998-1212
                                </p>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row mt-4">

                    <h4 class="mb-4 mt-4">
                        <u>
                            Mail Us at
                        </u>
                    </h4>

                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">
                                    Support
                                </h5>
                                <p class="mb-0">
                                    support@mail.com
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">
                                    Inquiry
                                </h5>
                                <p class="mb-0">
                                    inquiry@mail.com
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">
                                    Sales
                                </h5>
                                <p class="mb-0">
                                    sales@mail.com
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>






            <div class="footer-section mt-5">
                <center>
                    <p class="text-center">Copyright © NETLEXER. All rights reserved.</p>
                </center>

            </div>
            <script src="<?php echo e(asset('src/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
            <script src="<?php echo e(asset('src/plugins/perfect-scrollbar/perfect-scrollbar.min.js')); ?>"></script>
            <script src="<?php echo e(asset('src/plugins/mousetrap/mousetrap.min.js')); ?>"></script>
            <script src="<?php echo e(asset('src/plugins/src/notification/snackbar/snackbar.min.js')); ?>"></script>
            <script src="<?php echo e(asset('src/assets/js/components/notification/custom-snackbar.js')); ?>"></script>
            <script src="<?php echo e(asset('src/custom.js')); ?>"></script>

            <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4="
                crossorigin="anonymous"></script>

            <script>
                $(document).ready(function() {
                    $.ajax({
                        url: "<?php echo e(route('getMonthlyPackage')); ?>",
                        type: 'GET',
                        success: function(data) {
                            $('#package').html(data.html);
                        }
                    });


                    $('#toggle-1').change(function() {
                        if ($(this).is(':checked')) {
                            $.ajax({
                                url: "<?php echo e(route('getMonthlyPackage')); ?>",
                                type: 'GET',
                                success: function(data) {
                                    $('#type-button').addClass('show');
                                    $('#package').html(data.html);
                                }
                            });
                        } else {
                            $.ajax({

                                url: "<?php echo e(route('getYearlyPackage')); ?>",
                                type: 'GET',
                                success: function(data) {
                                    $('#type-button').removeClass('show');
                                    $('#package').html(data.html);
                                }
                            });
                        }
                    });

                });
            </script>

            <?php if(session('error')): ?>
                <script>
                    error_alert('<?php echo e(session('error')); ?>');
                </script>
            <?php endif; ?>

</body>

</html>
<?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/web/index.blade.php ENDPATH**/ ?>