<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>Forgot Password | Rent a MailBox</title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('favicon-logo.ico')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('layouts/modern-light-menu/css/light/loader.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('layouts/modern-light-menu/css/dark/loader.css')); ?>" type="text/css">
    <script src="<?php echo e(asset('layouts/modern-light-menu/loader.js')); ?>"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:400,600,700">
    <link rel="stylesheet" href="<?php echo e(asset('src/bootstrap/css/bootstrap.min.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('layouts/modern-light-menu/css/light/plugins.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('src/assets/css/light/authentication/auth-boxed.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('layouts/modern-light-menu/css/dark/plugins.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('src/assets/css/dark/authentication/auth-boxed.css')); ?>" type="text/css">


</head>

<body class="form">

    <!-- BEGIN LOADER -->
    <div id="load_screen">
        <div class="loader">
            <div class="loader-content">
                <div class="spinner-grow align-self-center"></div>
            </div>
        </div>
    </div>
    <!--  END LOADER -->

    <div class="auth-container d-flex">

        <div class="container mx-auto align-self-center">

            <div class="row">

                <div class="col-xxl-4 col-xl-5 col-lg-5 col-md-8 col-12 d-flex flex-column align-self-center mx-auto">
                    <div class="card mt-3 mb-3">
                        <div class="card-body">

                            <div class="brand-logo mt-3 mb-4">
                                <center>
                                    <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('rent-a-mailbox-logo.png')); ?>"
                                            alt="" srcset="" width="230"></a>
                                </center>
                            </div>


                            <form action="<?php echo e(url('app/forgot-password')); ?>" method="POST">
                                <?php echo csrf_field(); ?>

                                <div class="row">
                                    <div class="col-md-12 mb-3">

                                        <h2>Fogot Password</h2>
                                        <p>Enter your email to reset your password</p>

                                        <?php if(session('error')): ?>
                                            <div class="alert alert-danger mt-4">
                                                <?php echo e(session('error')); ?>

                                            </div>
                                        <?php endif; ?>

                                        <?php if(session('success')): ?>
                                            <div class="alert alert-success mt-4">
                                                <?php echo e(session('success')); ?>

                                            </div>
                                        <?php endif; ?>

                                    </div>

                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label class="form-label">Email</label>
                                            <input type="email" class="form-control" name="email" autocomplete="off"
                                                required>
                                        </div>
                                    </div>


                                    <div class="col-12">
                                        <div class="mb-4">
                                            <button class="btn btn-secondary w-100">SEND RESET LINK</button>
                                        </div>
                                    </div>

                                </div>

                            </form>


                        </div>
                    </div>
                </div>

            </div>

        </div>

    </div>

    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="<?php echo e(asset('src/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->


</body>

</html>
<?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/app/auth/forgot-password.blade.php ENDPATH**/ ?>