<?php if(Auth::user()->pendingInvoice() > 0): ?>
    <div class="card mt-5">
        <div class="card-body bg-danger">
            <h2 class="text-white">
                Hi <?php echo e(Auth::user()->full_name); ?> - #<?php echo e(Auth::user()->user_id); ?>

            </h2>
            <p class="text-white">
                Your subscription almost expired. Please pay your pending invoice to avoid service interruption. After
                <?php echo e(now()->diffInDays(Auth::user()->sub_end_date)); ?> days, your account will be deactivated.
            </p>
            <a href="<?php echo e(url('app/invoice-history')); ?>" class="text-white"><b>Click here to view invoice history</b></a>
        </div>
    </div>
<?php else: ?>
    <div class="card mt-5">
        <div class="card-body">
            <h2>
                Hi <?php echo e(Auth::user()->full_name); ?> - #<?php echo e(Auth::user()->user_id); ?>

            </h2>
            <p>
                Your subscription is currently active and will expire in <span
                    class="badge badge-danger"><?php echo e(now()->diffInDays(Auth::user()->sub_end_date)); ?></span> days.
            </p>
            <a href="<?php echo e(url('app/invoice-history')); ?>" class="text-white"><b>Click here to view invoice history</b></a>
        </div>
    </div>
<?php endif; ?>



<div class="row layout-top-spacing">
    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12 layout-spacing">
        <div class="widget widget-card-five">
            <div class="widget-content">
                <div class="account-box">
                    <div class="info-box">
                        <div class="icon">
                            <span>
                                <img src="<?php echo e(asset('src/assets/img/inbox-unread.png')); ?>" alt="money-bag">
                            </span>
                        </div>

                        <div class="balance-info">
                            <h5>Unread Messages</h5>
                            <p>
                                <?php echo e($unread_messages); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12 layout-spacing">
        <div class="widget widget-card-five">
            <div class="widget-content">
                <div class="account-box">
                    <div class="info-box">
                        <div class="icon">
                            <span>
                                <img src="<?php echo e(asset('src/assets/img/email-read.png')); ?>" alt="money-bag">
                            </span>
                        </div>

                        <div class="balance-info">
                            <h5>Read Messages</h5>
                            <p>
                                <?php echo e($read_messages); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 col-12 layout-spacing">
        <div class="widget widget-card-five">
            <div class="widget-content">
                <div class="account-box">
                    <div class="info-box">
                        <div class="icon">
                            <span>
                                <img src="<?php echo e(asset('src/assets/img/email-inbox.png')); ?>" alt="money-bag">
                            </span>
                        </div>

                        <div class="balance-info">
                            <h5>Total Messages</h5>
                            <p>
                                <?php echo e($total_messages); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/app/components/user-dashboard-card.blade.php ENDPATH**/ ?>