<?php

use App\Http\Controllers\AddressBookController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ClientInfoController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MailboxAttachmentController;
use App\Http\Controllers\MailboxController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\ServicePackageController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\UserTempController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get("app/login", [AuthController::class, "login"]);
Route::post("app/login", [AuthController::class, "loginSubmit"]);
Route::get("app/logout", [AuthController::class, "logout"]);
Route::get("app/get-started", [AuthController::class, "register"]);
Route::post("app/register", [UserTempController::class, "store"]);
Route::get("app/otp-verify", [UserTempController::class, "otpVerify"]);
Route::post("app/otp-verify", [UserTempController::class, "otpVerifySubmit"]);

Route::get("app/forgot-password", [AuthController::class, "forgotPassword"]);
Route::post("app/forgot-password", [AuthController::class, "forgotPasswordSubmit"]);
Route::get("app/reset-password", [AuthController::class, "resetPassword"]);
Route::post("app/reset-password", [AuthController::class, "resetPasswordSubmit"]);

Route::group(["middleware" => ["auth"], "prefix" => "app"], function () {
    Route::get("invoice-for-new-customer", [PaymentController::class, "invoiceForNewCustomer"]);
    Route::post("make-payment", [PaymentController::class, "makePayment"]);
    Route::get("stripe/payment-success", [PaymentController::class, "stripePaymentSuccess"]);
    Route::get("paypal/payment-success", [PaymentController::class, "paypalPaymentSuccess"]);
    Route::group(["middleware" => "subs_user"], function () {
        Route::get("welcome-wiz", [DashboardController::class, "wizard"]);
        Route::get("/", [DashboardController::class, "dashboard"])->name("dashboard");
        Route::resource("service-package", ServicePackageController::class)->name("index", "service-packages.index");
        Route::resource("users", UserController::class)->name("index", "users.index");
        Route::get("mailbox", [MailboxController::class, "mailbox"])->name("mailbox");
        Route::get("mailbox/{mailbox}", [MailboxController::class, "mailDetailClient"])->name("mail-view");
        Route::resource("address-book", AddressBookController::class)->name("index", "address-book.index");
        Route::get("invoice-history", [PaymentController::class, "invoiceHistory"])->name("invoice-history");
        Route::get("client-list", [ClientInfoController::class, "clientList"])->name("clients");
    });
    Route::get("client-profile-modal/{client_id}", [ClientInfoController::class, "clientProfileModal"]);
    Route::get("invoice/{invoice_number}", [PaymentController::class, "invoiceHistoryDetail"])->name("invoice-history-detail");
    Route::get("setting/module-permission", [PermissionController::class, "modulePermission"])->name("module-permission");
    Route::get("setting/get-permission-by-role", [PermissionController::class, "getPermissionByRole"]);
    Route::post("setting/update-permission", [PermissionController::class, "updatePermission"]);
    Route::get("setting/profile", [ClientInfoController::class, "getUserProfile"])->name("profile");
    Route::post("setting/profile/update", [ClientInfoController::class, "updateProfile"]);
    Route::post("setting/profile/update-scan-permission", [ClientInfoController::class, "updateScanPermission"]);
    Route::get("mail-entry", [MailboxController::class, "mailEntry"])->name("mail-entry");
    Route::post("get-mail-entry-form", [MailboxController::class, "mailEntryForm"])->name("mail-entry-form");
    Route::post("mail-entry-submit", [MailboxController::class, "mailEntryFormStore"]);
    Route::get("mail-list", [MailboxController::class, "mailList"])->name("mail-list");
    Route::get("mail-detail/{id}", [MailboxController::class, "mailDetail"])->name("mail-detail");
    Route::post("mailbox/mail-scan-permission", [MailboxController::class, "mailScanPermissionUpdate"]);
    Route::get("attachment-entry", [MailboxAttachmentController::class, "pendingAttachmentEntry"])->name("attachment-entry");
    Route::post("upload-mail-attachment", [MailboxAttachmentController::class, "uploadMailAttachment"]);

    Route::get("download-attachment/{id}", [MailboxAttachmentController::class, "downloadAttachment"]);
});
