@extends('app.layouts.app')
@section('title', 'Client List')
@section('header')
    @include('app.components.datatable-css')
@endsection

@section('content')
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="page-meta mt-5">
                <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                    <div class="row">
                        <div class="col">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active" aria-current="page">Client List</li>
                            </ol>
                        </div>
                        <div class="col text-right d-flex justify-content-end">
                        </div>
                    </div>
                </nav>
            </div>



            <div class="row layout-top-spacing">

                <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
                    <div class="widget-content widget-content-area br-8">

                        <table id="zero-config" class="table dt-table-hover" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone Number</th>
                                    <th>Package</th>
                                    <th>Subscription</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($clients as $item)
                                    <tr id="item_{{ $item->id }}">
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $item->full_name }} ({{ $item->user_id }})</td>
                                        <td>{{ $item->email }}</td>
                                        <td>{{ $item->phone_number }}</td>
                                        <td>{{ $item->package->package_name }},
                                            {{ $item->package->serviceCategory->service_category_name }}</td>
                                        <td>
                                            @if ($item->sub_start_date)
                                                {{ DT($item->sub_start_date) }} - {{ DT($item->sub_end_date) }}
                                            @else
                                            @endif
                                        </td>
                                        <td>
                                            <button class="btn-crud" onclick="viewItem({{ $item->id }})">
                                                <span class="material-symbols-outlined">
                                                    visibility
                                                </span>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content" id="">

                <div class="modal-body" id="profile_details">
                    {{-- @include('app.mailbox.mail-detail') --}}


                </div>
            </div>
        </div>
    </div>

@endsection

@section('footer')
    @include('app.components.datatable-js')

    <script src="{{ asset('src/ajax.js') }}"></script>

    <script>
        function viewItem(id) {
            ajax_call('get', 'client-profile-modal/' + id).then(function(response) {
                console.log(response)
                $('#profile_details').html(response.html)
                $("#exampleModal").modal("show");
            }).catch(function(error) {
                console.error('Error:', error);
            });

        }
    </script>



@endsection
