@extends('app.layouts.app')
@section('title', 'Module Permission')
@section('header')

@endsection

@section('content')
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="page-meta mt-5">


                <div class="card">
                    <div class="card-body">


                        <div class="row">
                            <div class="col-md-6">
                                <h6>User Role</h6>
                                <select class="form-select" id="role_select" style="width: 60%">
                                    <option value="0">Select Role</option>
                                    @foreach ($role as $item)
                                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                                    @endforeach
                                </select>

                            </div>
                            <div class="col-md-6">

                                <div id="permission_div">

                                </div>


                            </div>
                        </div>




                    </div>
                </div>
            </div>

        </div>
    </div>

    <div id="crud_modal"></div>


@endsection

@section('footer')

    <script src="{{ asset('src/ajax.js') }}"></script>

    <script>
        $('#role_select').change(function() {

            var url = "get-permission-by-role?role_id=" + $('#role_select').val();
            ajax_call('get', url).then(function(response) {
                 $('#permission_div').html(response.html);

            }).catch(function(error) {
                console.error('Error:', error);
            });

        });


        $(document).on('click', '#save_permission', function() {
            var permission = [];
            var role_id = $('#role_select').val();
            var url = "update-permission";
            $('#permission_input input[type=checkbox]').each(function() {
                if ($(this).is(':checked')) {
                    permission.push($(this).val());
                }
            });

            var data = {
                _token: "{{ csrf_token() }}",
                role_id: role_id,
                permissions: permission
            };

            console.log(data);

            ajax_call('post', url, data).then(function(response) {
                success_alert(response.message);
            }).catch(function(error) {
                alert('Something went wrong')
                console.error('Error:', error);
            });

        });


    </script>


@endsection
