@extends('app.layouts.app')
@section('title', 'Mail List')
@section('header')
    @include('app.components.datatable-css')
@endsection

@section('content')
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="page-meta mt-5">
                <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                    <div class="row">
                        <div class="col">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active" aria-current="page">Pending Attachments</li>
                            </ol>
                        </div>
                        <div class="col text-right d-flex justify-content-end">
                            {{-- <a href="{{ route('mail-entry') }}" class="btn btn-primary">Add New</a> --}}
                        </div>
                    </div>
                </nav>
            </div>



            <div class="row layout-top-spacing">

                <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
                    <div class="widget-content widget-content-area br-8">

                        <table id="zero-config" class="table dt-table-hover" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Tracking ID</th>
                                    <th>Title</th>
                                    <th>Client</th>
                                    <th>Mail From</th>
                                    <th>Scan Permission</th>
                                    <th>Date</th>
                                    <th class="no-content">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($mails as $item)
                                    <tr id="item_{{ $item->id }}">
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $item->mail_id }}</td>
                                        <td>{{ $item->title }}</td>
                                        <td>{{ $item->client->full_name }} ({{ $item->client->user_id }})</td>
                                        </td>
                                        <td>{{ $item->address_book_name }}</td>
                                        <td>
                                            @if ($item->scan_permission == 1)
                                                <span class="badge badge-success">Yes</span>
                                            @else
                                                <span class="badge badge-danger">No</span>
                                            @endif

                                        </td>
                                        <td>{{ $item->created_at }}</td>
                                        <td>
                                            <button class="btn-crud" onclick="viewItem({{ $item->id }})">
                                                <span class="material-symbols-outlined">
                                                    visibility
                                                </span>
                                            </button>


                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content" id="">

                <div class="modal-body" id="mail_details">
                    {{-- @include('app.mailbox.mail-detail') --}}


            </div>
            </div>
        </div>



@endsection

@section('footer')
    @include('app.components.datatable-js')
<script src="{{ asset('src/ajax.js') }}"></script>

    <script>
        function viewItem(id) {
            ajax_call('get', 'mail-detail/'+id).then(function(response) {

                console.log(response)
                $('#mail_details').html(response.html)
                $("#exampleModal").modal("show");
            }).catch(function(error) {
                console.error('Error:', error);
            });

        }

    </script>



@endsection
