<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>Sign In | Rent a MailBox</title>
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon-logo.ico') }}" />
    <link rel="stylesheet" href="{{ asset('layouts/modern-light-menu/css/light/loader.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('layouts/modern-light-menu/css/dark/loader.css') }}" type="text/css">
    <script src="{{ asset('layouts/modern-light-menu/loader.js') }}"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:400,600,700">
    <link rel="stylesheet" href="{{ asset('src/bootstrap/css/bootstrap.min.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('layouts/modern-light-menu/css/light/plugins.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('src/assets/css/light/authentication/auth-boxed.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('layouts/modern-light-menu/css/dark/plugins.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('src/assets/css/dark/authentication/auth-boxed.css') }}" type="text/css">


</head>

<body class="form">

    <!-- BEGIN LOADER -->
    <div id="load_screen">
        <div class="loader">
            <div class="loader-content">
                <div class="spinner-grow align-self-center"></div>
            </div>
        </div>
    </div>
    <!--  END LOADER -->

    <div class="auth-container d-flex">

        <div class="container mx-auto align-self-center">

            <div class="row">

                <div class="col-xxl-4 col-xl-5 col-lg-5 col-md-8 col-12 d-flex flex-column align-self-center mx-auto">
                    <div class="card mt-3 mb-3">
                        <div class="card-body">

                            <div class="brand-logo mt-3 mb-4">
                                <center>
                                    <a href="{{ url('/') }}"><img src="{{ asset('rent-a-mailbox-logo.png') }}"
                                            alt="" srcset="" width="230"></a>
                                </center>
                            </div>


                            <form action="{{ url('app/login') }}" method="POST">
                                @csrf

                                <div class="row">
                                    <div class="col-md-12 mb-3">

                                        <h2>Sign In</h2>
                                        <p>Enter your email and password to login</p>

                                        @if (session('error'))
                                            <div class="alert alert-danger mt-4">
                                                {{ session('error') }}
                                            </div>
                                        @endif

                                        @if (session('success'))
                                            <div class="alert alert-success mt-4">
                                                {{ session('success') }}
                                            </div>
                                        @endif
                                    </div>

                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label class="form-label">Email</label>
                                            <input type="email" class="form-control" name="email" autocomplete="off"
                                                required>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="mb-4">
                                            <label class="form-label">Password</label>
                                            <input type="password" class="form-control" name="password"
                                                autocomplete="off" required>
                                        </div>
                                    </div>


                                    <div class="col-12">
                                        <div class="mb-4">
                                            <button class="btn btn-secondary w-100">SIGN IN</button>
                                        </div>
                                    </div>



                                    <div class="col-12">

                                        <div class="text-center">
                                            <p class="mb-0">Forgot Password ? <a
                                                    href="{{ url('app/forgot-password') }}" class="text-warning">Reset
                                                    Password</a>
                                            </p>
                                        </div>

                                        <div class="text-center">
                                            <p class="mb-0">Dont't have an account ? <a
                                                    href="{{ url('app/get-started') }}" class="text-warning">Sign
                                                    Up</a>
                                            </p>
                                        </div>
                                    </div>

                                </div>

                            </form>


                        </div>
                    </div>
                </div>

            </div>

        </div>

    </div>

    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="{{ asset('src/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->


</body>

</html>
