<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
         $data = [
            [
                'id' => 1,
                'icon' => 'dashboard',
                'name' => 'dashboard',
                'display_name' => 'Dashboard',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],
            [
                'id' => 2,
                'icon' => 'mail',
                'name' => 'mailbox',
                'display_name' => 'Mailbox',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],
            [
                'id' => 3,
                'icon' => 'import_contacts',
                'name' => 'address-book.index',
                'display_name' => 'Address Book',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],
            [
                'id' => 4,
                'icon' => 'settings',
                'name' => 'profile',
                'display_name' => 'Settings',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],
            [
                'id' => 5,
                'icon' => 'receipt_long',
                'name' => 'invoice-history',
                'display_name' => 'Invoice History',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],
            [
                'id' => 6,
                'icon' => 'group',
                'name' => 'clients',
                'display_name' => 'Clients',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],
            [
                'id' => 7,
                'icon' => 'group',
                'name' => 'users.index',
                'display_name' => 'Users',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],
            [
                'id' => 8,
                'icon' => 'package_2',
                'name' => 'service-packages.index',
                'display_name' => 'Service Package',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],
            [
                'id' => 9,
                'icon' => '#',
                'name' => 'module-permission',
                'display_name' => 'Module Permission',
                'group_name' => 'System Settings',
                'guard_name' => '*'
            ],
            [
                'id' => 10,
                'icon' => 'mail',
                'name' => 'mail-entry',
                'display_name' => 'Mail Entry',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],
            [
                'id' => 11,
                'icon' => 'stacked_email',
                'name' => 'mail-list',
                'display_name' => 'Mail List',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],
            [
                'id' => 12,
                'icon' => 'attach_email',
                'name' => 'attachment-entry',
                'display_name' => 'Attachment Entry',
                'group_name' => 'Root',
                'guard_name' => '*'
            ],

         ];

         Permission::insert($data);

    }
}
