<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('address_books', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->references('id')
                ->on('users')->onDelete('restrict');
            $table->string('name');
            $table->string('contact_email')->nullable();
            $table->unsignedTinyInteger('country_code_id')->nullable();
            $table->string('contact_phone')->nullable();
            $table->string('address');
            $table->string('note')->nullable();
            $table->string('city');
            $table->string('province');
            $table->unsignedInteger('country_id');
            $table->string('postal_code');
            $table->decimal('lat', 11, 8)->nullable();
            $table->decimal('long', 11, 8)->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('address_books');
    }
};
