<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('user_id')->nullable();
            $table->string('full_name');
            $table->string('email')->unique();
            $table->string('password');
            $table->timestamp('email_verified_at')->nullable();
            $table->unsignedInteger('country_code_id')->nullable();
            $table->string('phone_number')->nullable();
            $table->dateTime('phone_verified_at')->nullable();
            $table->tinyInteger('user_type_id')->default(1);
            $table->tinyInteger('spac_id')->nullable();
            $table->dateTime('sub_start_date')->nullable();
            $table->dateTime('sub_end_date')->nullable();
            $table->tinyInteger('scan_permission')->comment('0: Need to permission for scan, 1: scan allowed')->default(1);
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
