<?php

use Illuminate\Support\Str;


if (!function_exists('successResponse')) {
    function successResponse($message = '', $statusCode = 200, $data = null)
    {
        $response = [
            'success' => true,
            'message' => $message,
            'data' => $data
        ];
        if (empty($data)) {
            $response['data'] = [];
        }

        return response()->json($response, $statusCode);
    }
}

if (!function_exists('errorResponse')) {
    function errorResponse($message = '', $statusCode = 500, $errors = null)
    {
        $response = [
            'success' => false,
            'message' => $message,
            'errors' => $errors
        ];
        if (empty($errors)) {
            $response['errors'] = [];
        }

        return response()->json($response, $statusCode);
    }
}

if (!function_exists('DT')) {
    function DT($date, $format = 'd M Y')
    {
        return date($format, strtotime($date));
    }
}

if(!function_exists('fileUpload')) {
    function fileUpload($file, $path)
    {
        $path = 'uploads/' . $path;
        $fileName = time() . '_' . Str::random(40). '.' . $file->getClientOriginalExtension();
        $file->storeAs($path, $fileName, 'public');
        return $fileName;
    }
}
