<?php

namespace App\Services;

use App\Models\Mailbox;
use App\Models\MailboxAttachment;
use App\Models\ServicePackage;
use App\Models\User;

class MailBoxService
{
    protected $mailbox_row;
    public function store($request, $address, $address_book_id, $is_scanned, $ssp)
    {

        $mail_id = 'm-'.$this->trakingId();
        $mail_row = Mailbox::create([
            'client_id' => $request->user_id,
            'spac_id' => $request->spac_id,
            'mail_from' => $address_book_id,
            'title' => $request->title,
            'short_desc' => $request->short_desc,
            'scan_permission' => $request->scan_permission,
            'is_scanned' => $is_scanned,
            'from_mail' => $address,
            'mail_id' => $mail_id,
            'ssp_id' => $ssp
        ]);
        $this->mailbox_row = $mail_row;
        return $mail_id;
    }


    public function trakingId()
    {
        return Mailbox::orderBy('id', 'desc')->first()
        ? (int)str_replace('m-', '', Mailbox::orderBy('id', 'desc')->first()->mail_id) + 1
        : config('app.tracking_id');
    }

    public function storeAttachment($attachment, $attachment_title)
    {
        MailboxAttachment::create([
            'mailbox_id' => $this->mailbox_row->id,
            'attachment' => $attachment,
            'attachment_title' => $attachment_title
        ]);
    }

    public function getMailDetails($id)
    {
        $mail = Mailbox::with('client')
            ->select('mailboxes.*', 'address_books.name as address_book_name', 'mailbox_attachments.attachment', 'mailbox_attachments.attachment_title')
            ->leftJoin('address_books', 'mailboxes.mail_from', '=', 'address_books.id')
            ->leftJoin('mailbox_attachments', 'mailboxes.id', '=', 'mailbox_attachments.mailbox_id')
            ->where('mailboxes.id', $id)
            ->first();

        $user = (new UserService())->getUserProfile($mail->client_id);

        $address = $mail->from_mail;
        $address = json_decode($address, true);

        return [
            'mail' => $mail,
            'address' => $address,
            'user' => $user
        ];
    }


    public function getMailLeft($user){
        $ssp = $user->currentSSP->id;
        $mail_used = Mailbox::where('ssp_id', $ssp)->count();
        $limit = ServicePackage::where('id', $user->spac_id)->first()->qty;

        return $limit - $mail_used;
    }
}
