<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Mailbox extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    public function client()
    {
        return $this->belongsTo(User::class, 'client_id', 'id');
    }

    public function addressBook()
    {
        return $this->belongsTo(AddressBook::class, 'mail_from', 'id');
    }

}
