<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SubscribeUsers
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth()->user();


        if ($user->user_type_id != 1) {
            return $next($request);
        }

        if (!$user->sub_end_date) {
            return redirect('app/invoice-for-new-customer');
        }

        return $next($request);
    }
}
