<?php

namespace App\Http\Controllers;

use App\Http\Requests\ClientStoreRequest;
use App\Jobs\NewUserOtpMail as JobsNewUserOtpMail;
use App\Mail\NewUserOtpMail;
use App\Models\ServicePackage;
use App\Models\User;
use App\Models\UserTemp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\SubscriptionServicePackage;
use App\Services\PermissionService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;

class UserTempController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ClientStoreRequest $request)
    {


        $data = $request->only('full_name', 'email', 'password', 'country_code_id', 'phone_number', 'spac_id');
        $data['password'] = bcrypt($data['password']);
        $data['otp'] = rand(1000, 9999);

        try {
            DB::beginTransaction();
            $temp_user = UserTemp::create($data);
            $package = ServicePackage::where('id', $data['spac_id'])->first();

            $payable_amount = $package->price - ($package->price * $package->discount / 100);

            SubscriptionServicePackage::create([
                'spac_id' => $data['spac_id'],
                'client_temp_id' => $temp_user->id,
                'price' => $package->price,
                'discount' => $package->discount,
                'no_of_month' => $package->type = 'monthly' ? 1 : 12,
                'payable_amount' => $payable_amount,
                'invoice_number' => 'INV-' . time(),
            ]);
            $token = Str::random(30);
            $url = url('app/otp-verify?token=' . $token);
            session(['token' => $token]);
            session(['email' => $data['email']]);

            // dispatch(new JobsNewUserOtpMail($data));
            Mail::to($data['email'])->send(new NewUserOtpMail($data));
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            return $e->getMessage();
        }



        return redirect($url);
    }

    /**
     * Display the specified resource.
     */
    public function otpVerify(Request $request)
    {
        $token = $request->query('token');
        $s_token = session('token');
        if ($s_token != $token) {
            return redirect('app/get-started')->with('error', 'Please start the registration process again');
        }

        return view('app.auth.otp-verify', compact('token'));
    }

    public function otpVerifySubmit(Request $request)
    {
        $token = $request->query('token');
        $s_token = session('token');
        $email = session('email');


        if ($s_token != $token) {
            return redirect('app/get-started')->with('error', 'Please start the registration process again');
        }

        $otp = $request->num1 . $request->num2 . $request->num3 . $request->num4;

        $user = UserTemp::where('email', $email)->where('otp', $otp)->latest()->first();

        if (!$user) {
            return redirect('app/otp-verify?token=' . $token)->with('error', 'Invalid OTP');
        }

        $temp_id = $user->id;
        $data = $user->toArray();
        unset($data['otp']);
        unset($data['id']);
        unset($data['created_at']);
        unset($data['updated_at']);
        $data['user_id'] = User::max('user_id') + 1 ?? 10000;
        $data['email_verified_at'] = now();


        try {
            DB::beginTransaction();
            $client = User::create($data);
            DB::table('model_has_roles')->insert(['role_id' => 1, 'model_type' => 'App\Models\User', 'model_id' => $client->id]);
            SubscriptionServicePackage::where('client_temp_id', $temp_id)->update(['client_id' => $client->id]);
            Auth::login($client);



            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            return $e->getMessage();
        }
        session()->forget('token');
        session()->forget('email');

        $permission = (new PermissionService())->getPermissionByRole(1);
        Session::put('permission', $permission->groupBy('group_name'));


        return redirect('app/invoice-for-new-customer');
    }



    /**
     * Show the form for editing the specified resource.
     */
    public function edit(UserTemp $userTemp)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, UserTemp $userTemp)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(UserTemp $userTemp)
    {
        //
    }
}
