<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Role;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;


class UserController extends Controller
{
    public function index()
    {
        $users = User::with('role')->orderBy('id', 'desc')
            ->where('user_type_id', '!=', 1)
            ->get();

         return view('app.users.index', compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $title = 'Create User';
        $action = 'create';
        $user = false;
        $role = DB::table('roles')->whereNot('name', 'client')->get();
        $html = View::make('app.users.modal', compact('title', 'action', 'user', 'role'))->render();

        return response()->json(['html' => $html]);
    }


    public function store(Request $request)
    {
        $data = $request->only('full_name', 'email', 'password');
        $data['password'] = bcrypt($data['password']);
        $user = User::create($data);

        return successResponse('User created successfully', 201, $user);
    }

    public function show(User $user)
    {
        //
    }

    public function edit(User $user)
    {
        $title = 'Edit User';
        $action = 'update';
        $role = DB::table('roles')->whereNot('name', 'client')->get();
        $html = View::make('app.users.modal', compact('title', 'action', 'user', 'role'))->render();

        return response()->json(['html' => $html]);
    }

    public function update(Request $request, User $user)
    {
        $data = $request->only('full_name', 'email', 'password');
        $data['password'] = bcrypt($data['password']);
        $user->update($data);

        return successResponse('User updated successfully', 200, $user);
    }

    public function destroy(User $user)
    {
        $user->delete();
        return successResponse('User deleted successfully', 200);
    }
}
