<?php

namespace App\Http\Controllers;

use App\Models\SubscriptionServicePackage;
use App\Services\PaypalService;
use App\Services\StripeService;
use App\Services\SubscriptionService;
use Carbon\Carbon;
use Dotenv\Util\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Stripe\Stripe;
use Stripe\Charge;

class PaymentController extends Controller
{

    protected $stripeService;
    protected $paypalService;

    public function __construct()
    {
        $this->stripeService = new StripeService();
        $this->paypalService = new PaypalService();
    }


    public function invoiceForNewCustomer(Request $request)
    {



        $message = 'Your Order Summary';
        $invoice = SubscriptionServicePackage::with(['servicePackage', 'client'])->where('client_id', Auth::id())->where('payment_method', null)->latest()->first();

        if (!$invoice) {
            return redirect('app');
        }

        $html = view('app.payment.invoice-body', compact('invoice'))->render();


        return view('app.payment.invoice-for-new-customer', compact('invoice', 'message', 'html'));
    }

    public function makePayment(Request $request)
    {

        $invoice = SubscriptionServicePackage::with(['servicePackage'])->where('id', $request->invoice_id)->first();

        if ($request->payment_method == 'stripe') {
            $response = $this->stripeService->payment($invoice);
            return $response;
        } elseif ($request->payment_method == 'paypal') {
            $response = $this->paypalService->payment($invoice);
            return $response;
        } else {
            return response()->json(['message' => 'Payment method not found'], 404);
        }
    }


    public function stripePaymentSuccess(Request $request, SubscriptionService $subscriptionService)
    {
        $stripe = new \Stripe\StripeClient(
            config('stripe.sk')
        );
        $payment_details = $stripe->checkout->sessions->retrieve($request->session_id);


        try {
            $subscriptionService->stripeSubscribeSuccess($request->invoice_id, $payment_details);
            // return redirect('app')->with('subscribe-success', 'Payment successful');
            return redirect('app/welcome-wiz')->with('subscribe-success', 'Payment successful');

        } catch (\Exception $e) {
            return redirect('app')->with('error', $e->getMessage());
        }
    }

    public function invoiceHistory(Request $request)
    {
        $invoices = SubscriptionServicePackage::with(['servicePackage', 'client'])->whereNotNull('client_id');
        if (Auth::user()->user_type_id == 1) {
            $invoices->where('client_id', Auth::id())->latest();
        } else {
            $invoices->latest();
        }

        $invoices = $invoices->get();




        return view('app.payment.invoice-history', compact('invoices'));
    }

    public function invoiceHistoryDetail(Request $request)
    {

        $invoice = SubscriptionServicePackage::with(['servicePackage', 'client'])->where('invoice_number', $request->invoice_number)->first();

        if (!$invoice) {
            return redirect('app')->with('error', 'Invoice not found');
        }


        if ($invoice->client_id != Auth::id() && Auth::user()->user_type_id == 1) {

            return redirect('app')->with('error', 'You are not authorized to view this invoice');
        }



        $html = view('app.payment.invoice-body', compact('invoice'))->render();

        return view('app.payment.invoice-details', compact('invoice', 'html'));
    }
}
